#ifndef GST_CU_STABLE_GRPC_ACCESS_H__
#define GST_CU_STABLE_GRPC_ACCESS_H__

#include "Client/ClientUtils/Network/StableNetworkInterface.h"

namespace GST
{
namespace ClientUtils
{
class GRPCAccess;

class GST_API_EXPORT StableGRPCAccess : public StableNetworkInterface
{
public:
	StableGRPCAccess(HostPtr host);
	~StableGRPCAccess();
	long BeginCommit(const std::string &message) const override;

	void connect() override;

	void CreateElement(ElementPtr Element,
					   bool uniqueName = false) const override;

	LinkAdjacencyPtr CreateLinkAdjacency(LinkAdjacency::LinkId parent,
										 LinkAdjacency::ReferId refId,
										 LinkAdjacency::TargetType refTarget,
										 Owner::OwnerId owner) const override;
	LinkAdjacencyPtr CreateLinkAdjacency(LinkAdjacency::LinkId parent,
										 LinkAdjacency::ReferId refId,
										 LinkAdjacency::TargetType refTarget,
										 Owner::OwnerId owner,
										 int64_t siblingRank) const override;

	void DeleteFeature(long id) const override;

	void DeleteRecord(const GST::ClientUtils::TableAttributeVal &attribute,
					  bool quoteTablename = true) const override;

	void disconnect() override;

	void DropLinkAdjacency(LinkAdjacency::LinkId linkId) const override;

	int EndCommit(long commitKey) const override;

	StableNetworkPtr fork() const override;

	OwnerListPtr GetAllOwners() const override;

	LinkAdjacencyListPtr GetChilds(LinkAdjacency::LinkId parent) const override;

	ConstrainedTableAttributeValArrayPtr GetConstrainedPropertyValues(
		const TableAttributeDesc &cp) const override;

	UserPtr getCurrentGSTUser() const override;

	AssignableElementListPtr GetElements(Owner::OwnerId owner) const override;

	CrudeFeaturePtr GetFeature(const FeatureDesc &feature,
							   Geometry::SRSPtr srs,
							   const boost::optional<AreaLimiter> &areaLimiter,
							   bool lock = false,
							   long commitKey = -1) const override;

	FeatureDescPtr GetFeatureDescByGeomId(const long &idgeo) const override;

	FeatureDescPtr GetFeatureDescByLockId(
		const std::string &lockid) const override;

	LockInfoListPtr GetLockInfo(long idgeo) const override;

	ObjectPropertyDescListPtr GetObjectPropertyList(
		const FeatureClassDesc &featureClass,
		bool filterMemberProperties = true) const override;

	ObjectPropertyDescListBySubFeatureKind
	GetObjectPropertyListBySubfeatureKind(
		const FeatureClassDesc &featureClass) const override;

	TableAttributeValListPtr GetObjectPropertyValues(const FeatureDesc &feature,
													 long commitKey
													 = -1) const override;

	OwnerListPtr GetOwners() const override;

	SimplexPropertyDescListPtr GetSimplexPropertyList(
		const FeatureClassDesc &featureClass) const override;

	SimplexPropertyDescListBySubFeatureKind
	GetSimplexPropertyListBySubfeatureKind(
		const FeatureClassDesc &featureClass) const override;

	Geometry::SRSItemValPtr GetSRSDefinition(long srsKey) const override;

	DataTablePtr GetTableValues(const std::string &tablename,
								const TableAttributeDescList &selection
								= TableAttributeDescList(),
								const std::string &filter
								= std::string()) const override;

	std::string getUserName() const override;

	void InsertRecord(const GST::ClientUtils::TableAttributeValList &attributes,
					  bool quoteTablename = true) const override;

	Geometry::GSTSRSRefPtr InsertSRS(const Geometry::SRS &new_srs,
									 const std::string &label,
									 const std::string &code_type
									 = std::string(),
									 const std::string &code_value
									 = std::string()) const override;

	bool isConnected() const override;

	bool isSuperUserConnection() const override;

	AssignableFeatureDescListPtr ListAllFeatures(
		const FeatureClassDesc &featureClass) const override;

	Geometry::SRSItemDescListPtr ListAllSRS() const override;

	NamesListPtr ListAllTables() const override;

	std::vector<TableDescription> ListAllTablesEx() const override;

	CommitListPtr ListCommits() const override;

	CommitListPtr ListCommitsByFeature(long geometryId) const override;

	FeatureClassDescListPtr ListFeatureClasses() const override;

	MoMaPropertyValueListPtr ListMoMaPropertyValues(
		const LinkedElement &element) const override;

	std::string LockGeometry(long idgeo) const override;

	StableNetworkPtr reconnect(const std::string &user,
							   const std::string &pwd,
							   const std::string &db
							   = std::string()) const override;

	FeatureClassDescPtr ResolveFeatureClassFromGeometryId(
		const long &geometryId) const override;

	void UnlockByKey(const std::string &key) const override;

	FeatureDescPtr UploadNewFeature(const Geometry::GeometryBuilder &feature,
									const FeatureClassDesc &target,
									long commitKey = -1) const override;

	void UpdateFeature(const Geometry::GeometryBuilder &feature,
					   const std::string &lockid,
					   const FeatureClassDesc &target,
					   long commitKey = -1,
					   bool keepLock = false) const override;

	void UpdateObjectPropertyValues(
		const FeatureDesc &feature,
		const TableAttributeValList &values) const override;

	void UpdateTableValues(RecordPtr record) const override;

private:
	friend class GRPCAccess;
	class Impl;
	Impl *m_impl;
};

} // namespace ClientUtils
} // namespace GST
#endif // GST_CU_STABLE_GRPC_ACCESS_H__
